<?php
// Add new input type "dropdown"
if ( function_exists('smile_add_input_type'))
{
	smile_add_input_type('dropdown' , 'dropdown_settings_field' );
	add_action( 'admin_enqueue_scripts', 'framework_dropdown_admin_styles' );
}


function framework_dropdown_admin_styles($hook){
	$cp_page = strpos( $hook, 'plug_page');

	if( $cp_page == 7 && isset( $_GET['developer'] ) ){
		wp_enqueue_script( 'smile-dropdown-script', SMILE_FRAMEWORK_URI . '/lib/fields/dropdown/dropdown.js', array(), '1.0.0', true );
	}
}

/**
* Function to handle new input type "dropdown"
*
* @param $settings		- settings provided when using the input type "dropdown"
* @param $value			- holds the default / updated value
* @return string/html 	- html output generated by the function
*/
function dropdown_settings_field($name, $settings, $value)
{
	$input_name = $name;
	$type = isset($settings['type']) ? $settings['type'] : '';
	$class = isset($settings['class']) ? $settings['class'] : '';
	$options = isset($settings['options']) ? $settings['options'] : '';
	
	//	Apply partials
	$partials =	generate_partial_atts( $settings );

	$output = '<p><select name="' . $input_name . '" id="smile_'.$input_name.'" class="form-control smile-input smile-select ' . $input_name . ' ' . $type . '" '.$partials.'>';
	foreach ( $options as $text_val => $val ) {
		if ( is_numeric( $text_val ) && ( is_string( $val ) || is_numeric( $val ) ) ) {
			$text_val = $val;
		}
		$text_val = __( $text_val, "smile" );
		$selected = '';
		if ( $value !== '' && (string)$val === (string)$value ) {
			$selected = ' selected="selected"';
		}
		$output .= '<option class="smile_' . $val . '" value="' . $val . '"' . $selected . '>' . htmlspecialchars( $text_val ) . '</option>';
	}
	$output .= '</select></p>';
	return $output;
}